/******************************************************************************/
class SetFloat : BaseEvent
{
public:
            SetFloat();
   virtual ~SetFloat();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_FloatUID;
   VarFloat* m_VarFloat;
   float m_Value, m_OrigValue;
   ENUM_FLOAT_OPERATIONS m_FloatOperation;
   bool m_Wrap;
   float m_WrapMax, m_WrapMin;
};
/******************************************************************************/
SetFloat::SetFloat() : BaseEvent(), m_Value(0), m_OrigValue(0), m_VarFloat(null), m_Wrap(false), m_WrapMax(0), m_WrapMin(0)              
{
   
}
SetFloat::~SetFloat()
{
   
}
/******************************************************************************/
void SetFloat::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("FloatOperation")) m_FloatOperation = (ENUM_FLOAT_OPERATIONS )p.asEnum();
   if(Param *p = obj.findParam("VarFloatUID"))    m_FloatUID       = p.asID();
   if(Param *p = obj.findParam("Value"))          m_Value          = p.asBool();
   if(Param *p = obj.findParam("Wrap"))           m_Wrap           = p.asBool();
   if(Param *p = obj.findParam("WrapMaximum"))    m_WrapMax        = p.asFlt();
   if(Param *p = obj.findParam("WrapMinimum"))    m_WrapMin        = p.asFlt();
   
   m_OrigValue = m_Value;
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SetFloat::AfterCreate()
{
   // Find the correct VarInt to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesFloat)
      if(variablesFloat[i].id() == m_FloatUID)
         m_VarFloat = &variablesFloat[i]; 
         
   DEBUG_ASSERT(m_VarFloat, "VarFloat not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SetFloat::CallTriggeredAction()
{
   float value = m_Value;
   
   if(m_Wrap)
   {   
      float diff = m_WrapMax - m_WrapMin;
      
      while(value > 0 ? m_Value > diff :  m_Value < -diff)
      {
         m_Value > 0 ? value -= diff :  value += diff;
      }  
   }

   float storedValue = m_VarFloat->GetValue();
   if(m_FloatOperation == FLOAT_SET_VALUE)
   {
      if(m_Wrap)
      {
         value = Clamp(m_Value, m_WrapMin,  m_WrapMax);
      }
      m_VarFloat->SetValue(value);
      
      if(m_LogDetailed || m_LogOutput)
      {
         LogN(S+"Start Trigger: Setting VarFloat (INFO: " + m_EditorInfo + " ) to: " + value);
      }      
   }

   else if(m_FloatOperation == FLOAT_ADD_VALUE)
   {
      if(m_Wrap)
      {
         float leftToAdd = value;
         float currValue = storedValue;
         bool positive = leftToAdd > 0;
         
         while(positive ? leftToAdd > 0 : leftToAdd < 0)
         {
            positive ? leftToAdd-- : leftToAdd++;
            
            if(positive ? currValue < m_WrapMax :  currValue > m_WrapMin)
            {
               positive ? currValue++ : currValue--;
            }
            else
            {
               currValue = positive ? m_WrapMin : m_WrapMax;
            }
         }
         m_VarFloat->SetValue(currValue);
         
         if(m_LogDetailed || m_LogOutput)
         {
            LogN(S+"Start Trigger: Incrementing VarFloat (INFO: " + m_EditorInfo + " ) with: " + value + ", from: " + m_Value + ", to: " + currValue);
         }         
      }
      else
      {
         if(m_LogDetailed || m_LogOutput)
         {
            LogN(S+"Start Trigger: Incrementing VarFloat (INFO: " + m_EditorInfo + " ) with: " + m_Value + ", from: " + m_VarFloat->GetValue() + ", to: " + (m_VarFloat->GetValue() + m_Value));
         }
         
         m_VarFloat->AddValue(m_Value);    
      }
   }
   
}

// This method is called when the duration of the event has been reached
void SetFloat::StopTriggeredAction()
{
   if(m_LogDetailed || m_LogOutput)
   {
      LogN(S+" Stop Trigger: Setting VarFloat (INFO: " + m_EditorInfo + " ) with: " + m_VarFloat->GetValue() + ", to: " + m_OrigValue);
   }
   
   // If m_Duration is not -1, the int will be set back to its original value, after a while
   m_VarFloat->SetValue(m_OrigValue); 
}
/******************************************************************************/